# Changelog for CpML Schemas for eCM

This file describes the change history of the CpML schemas, starting with
eCM version 4.5.

Last changed: 04 December 2025

## Version 4.7
- Trade Confirmation and Broker Confirmation: add additional `AccountNumberOfBuyer` field for emission certificates
- Trade Confirmation and Broker Confirmation: add additional fields for renewable energy certificates: 
  `AccountNumberOfBuyer`, `RegistryOfDelivery`, `MinimumValidityUponDelivery\NumberOfPeriods`, 
  `MinimumValidityUponDelivery\TypeOfPeriod`,`CertificateQualityLabel`,`PlantCommissioningDate`,`PlantName` 


## Version 4.6
- Trade Confirmation and Broker Confirmation: add support for renewable energy certificates:
    - new choice between `EUATradeDetails` and new section `RenewableCertificateDetails`
- Trade Confirmation: relax requirements for GB power transactions: 
    - `AccountAndChargeInformation`:  `BuyerEnergyAccountIdentification`, `SellerEnergyAccountIdentification`, `TransmissionChargeIdentification` now optional
    - `ECVNA`:  `BSCPartyID`, `BuyerID`, `SellerID` now optional
- Update of `UnitOfMeasureType`: `ROC`, `GO`, `IREC`, `REC`, `REGO`, `ROGO` removed (renewable certificates use MWh as unit)
- Update of `EnergyProductTYpe`: `ReactivePower` removed (obsolete), `GO` changed to `GoO` (alignment with eSM), `LNG` added  
- Maintenance fixes to align with schemas in production (no spec violations):
    - CNF and BCN: Choice between `TotalVolumeUnit` and `TotalVolumeCurrency` is mandatory 
    - CNF and BCN: obsolete section `USElectricityTradeDetails` removed 
    - Box result: type of `Timestamp` changed from `ClockDateTimeType` to `UTCTimestampType`
    - Fields `UTI` and `VenueOfExecution` moved from `EFET-CNF-V4R3.xsd` to `EFET-ConfirmationDescription-V4R3.xsd` (no impact on XML structure)
    - Pattern of `UTCOffsetTimeStampType` and `ClockDateTimeType` updated to allow for 22nd century dates
    - obsolete types removed: `DeliveryContingencyType` and `DeliveryTypeType`
    - obsolete enum values `VV_FLT_SWP` and `OPT_VV_FLT_SWP` removed from `NotificationFieldType` 

## Version 4.5

- TradeConfirmation and BrokerConfirmation:
  - Fields `UTI` and `VenueOfExecution` added in header.
  - Fields `BuyerPartyLEI` and `BuyerPartyBranchInformation` added.
  - Fields `SellerPartyLEI` and `SellerPartyBranchInformation` added.
  - Type `NameType` extended from 35 characters to 60 characters to allow for longer trader names.  
- UnitOfMeasureType: 
  - Add missing value "Fee" (in spec since 4.4) 
    
